/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.SortedMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_11788;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12137;
import net.minecraft.class_12249;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_4722;
import net.minecraft.class_750;
import net.minecraft.class_9799;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DefaultSuperRenderTypeBuffer
implements SuperRenderTypeBuffer {
    private static final DefaultSuperRenderTypeBuffer INSTANCE = new DefaultSuperRenderTypeBuffer();
    protected SuperRenderTypeBufferPhase earlyBuffer = new SuperRenderTypeBufferPhase();
    protected SuperRenderTypeBufferPhase defaultBuffer = new SuperRenderTypeBufferPhase();
    protected SuperRenderTypeBufferPhase lateBuffer = new SuperRenderTypeBufferPhase();

    public static DefaultSuperRenderTypeBuffer getInstance() {
        return INSTANCE;
    }

    @Override
    public class_4588 getEarlyBuffer(class_1921 type) {
        return this.earlyBuffer.bufferSource.method_73477(type);
    }

    @Override
    public class_4588 method_73477(class_1921 type) {
        return this.defaultBuffer.bufferSource.method_73477(type);
    }

    @Override
    public class_4588 getLateBuffer(class_1921 type) {
        return this.lateBuffer.bufferSource.method_73477(type);
    }

    @Override
    public void draw() {
        this.earlyBuffer.bufferSource.method_22993();
        this.defaultBuffer.bufferSource.method_22993();
        this.lateBuffer.bufferSource.method_22993();
    }

    @Override
    public void draw(class_1921 type) {
        this.earlyBuffer.bufferSource.method_22994(type);
        this.defaultBuffer.bufferSource.method_22994(type);
        this.lateBuffer.bufferSource.method_22994(type);
    }

    private void drawLast() {
        this.earlyBuffer.bufferSource.method_37104();
        this.defaultBuffer.bufferSource.method_37104();
        this.lateBuffer.bufferSource.method_37104();
    }

    @Environment(value=EnvType.CLIENT)
    public static class SuperRenderTypeBufferPhase {
        private final class_750 fixedBufferPack = new class_750();
        private final SortedMap<class_1921, class_9799> fixedBuffers = (SortedMap)class_156.method_654((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
            map.put((Object)class_4722.method_24073(), (Object)this.fixedBufferPack.method_3154(class_11515.field_60923));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75965());
            map.put((Object)class_4722.method_24074(), (Object)this.fixedBufferPack.method_3154(class_11515.field_60925));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75972());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_76009());
            map.put((Object)class_4722.method_29382(), (Object)this.fixedBufferPack.method_3154(class_11515.field_60926));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_76545());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75977());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_24067());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_24069());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_24070());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_24071());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_4722.method_45783());
            map.put((Object)class_4722.method_24072(), (Object)new class_9799(786432));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75989());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75995());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75993());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75997());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, class_12249.method_75985());
            class_1088.field_21772.forEach(renderType -> SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, renderType));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, PonderRenderTypes.outlineSolid());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, CreateRenderTypes.translucent());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<class_1921, class_9799>)map, CreateRenderTypes.additive());
        });
        private final class_4597.class_4598 bufferSource = class_4597.method_22992(this.fixedBuffers, (class_9799)new class_9799(256));

        private static void put(Object2ObjectLinkedOpenHashMap<class_1921, class_9799> map, class_1921 type) {
            map.put((Object)type, (Object)new class_9799(type.method_22722()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record ParticleRenderState(class_11659.class_11947 particleGroupRenderer, class_11944.class_12041 preparedBuffers, class_11977.class_12051 particleBufferCache) {
        public void render(GpuTextureView colorTexture, GpuTextureView depthTexture, GpuBufferSlice projection, GpuBufferSlice fog, GpuTextureView lightTextureView, class_12137 lightSampler, class_1060 textureManager, boolean translucent) {
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Immediate draw for particle", colorTexture, OptionalInt.empty(), depthTexture, OptionalDouble.empty());){
                renderPass.setUniform("Projection", projection);
                renderPass.setUniform("Fog", fog);
                renderPass.bindTexture("Sampler2", lightTextureView, lightSampler);
                this.particleGroupRenderer.method_74324(this.preparedBuffers, this.particleBufferCache, renderPass, textureManager, translucent);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Dispatcher {
        private final DefaultSuperRenderTypeBuffer buffer;
        private final class_4618 outline;
        private final class_11684 renderDispatcher;
        private final Queue<class_11977.class_12051> availableBuffers = new ArrayDeque<class_11977.class_12051>();
        private final List<class_11977.class_12051> usedBuffers = new ArrayList<class_11977.class_12051>();

        public Dispatcher() {
            class_310 mc = class_310.method_1551();
            this.buffer = DefaultSuperRenderTypeBuffer.getInstance();
            class_4597.class_4598 bufferSource = this.buffer.defaultBuffer.bufferSource;
            this.outline = new class_4618();
            this.renderDispatcher = new class_11684(new class_11661(), mc.method_1541(), bufferSource, mc.method_72703(), this.outline, bufferSource, mc.field_1772);
        }

        public DefaultSuperRenderTypeBuffer getBuffer() {
            return this.buffer;
        }

        public class_11661 getSubmitNodeStorage() {
            return this.renderDispatcher.method_73003();
        }

        private @Nullable List<ParticleRenderState> extractParticles(class_4587 ms) {
            ArrayList<ParticleRenderState> list = new ArrayList<ParticleRenderState>();
            Matrix4fStack stack = RenderSystem.getModelViewStack();
            stack.pushMatrix();
            stack.mul((Matrix4fc)ms.method_23760().method_23761());
            for (class_11788 commandQueue : this.renderDispatcher.method_73003().method_73532().values()) {
                List commands = commandQueue.method_74330();
                if (commands.isEmpty()) continue;
                for (class_11659.class_11947 particleGroupRenderer : commands) {
                    class_11977.class_12051 particleBufferCache = this.availableBuffers.poll();
                    if (particleBufferCache == null) {
                        particleBufferCache = new class_11977.class_12051();
                    }
                    this.usedBuffers.add(particleBufferCache);
                    class_11944.class_12041 preparedBuffers = particleGroupRenderer.method_74755(particleBufferCache);
                    if (preparedBuffers == null) continue;
                    list.add(new ParticleRenderState(particleGroupRenderer, preparedBuffers, particleBufferCache));
                }
                commands.clear();
            }
            stack.popMatrix();
            return list.isEmpty() ? null : list;
        }

        private static void renderParticles(List<ParticleRenderState> particles, boolean translucent) {
            if (particles == null) {
                return;
            }
            GpuTextureView colorTexture = RenderSystem.outputColorTextureOverride;
            GpuTextureView depthTexture = RenderSystem.outputDepthTextureOverride;
            class_310 mc = class_310.method_1551();
            GpuTextureView lightTextureView = mc.field_1773.method_22974().method_71650();
            class_12137 lightSampler = RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR);
            class_1060 textureManager = mc.method_1531();
            GpuBufferSlice projection = RenderSystem.getProjectionMatrixBuffer();
            GpuBufferSlice fog = RenderSystem.getShaderFog();
            for (ParticleRenderState particle : particles) {
                particle.render(colorTexture, depthTexture, projection, fog, lightTextureView, lightSampler, textureManager, translucent);
            }
        }

        public void draw(class_4587 ms) {
            List<ParticleRenderState> particles = this.extractParticles(ms);
            this.renderDispatcher.method_73002();
            this.buffer.drawLast();
            this.buffer.draw(class_12249.method_75965());
            this.buffer.draw(class_4722.method_24073());
            this.buffer.draw(class_4722.method_24074());
            this.buffer.draw(class_12249.method_75972());
            this.buffer.draw(class_12249.method_76009());
            this.buffer.draw(class_4722.method_24067());
            this.buffer.draw(class_4722.method_24069());
            this.buffer.draw(class_4722.method_24070());
            this.buffer.draw(class_4722.method_24071());
            this.buffer.draw(class_4722.method_45783());
            this.buffer.draw(class_4722.method_24072());
            this.buffer.draw(class_12249.method_75989());
            this.buffer.draw(class_12249.method_75995());
            this.buffer.draw(class_12249.method_75993());
            this.buffer.draw(class_12249.method_75997());
            this.buffer.draw(class_12249.method_75985());
            Dispatcher.renderParticles(particles, false);
            class_1088.field_21772.forEach(this.buffer::draw);
            this.buffer.draw(PonderRenderTypes.outlineSolid());
            this.outline.method_23285();
            Dispatcher.renderParticles(particles, true);
            this.buffer.draw(class_4722.method_29382());
            this.buffer.draw(class_4722.method_76545());
            this.buffer.draw(class_12249.method_75977());
            this.buffer.draw(CreateRenderTypes.translucent());
            this.buffer.draw(CreateRenderTypes.additive());
            for (class_11977.class_12051 particleBufferCache : this.usedBuffers) {
                particleBufferCache.method_74836();
            }
            this.availableBuffers.addAll(this.usedBuffers);
            this.usedBuffers.clear();
        }
    }
}

